/*
 * Decompiled with CFR 0.152.
 */
package calendar2.com.toedter.calendar;

import calendar2.com.toedter.calendar.JDayChooser;
import calendar2.com.toedter.calendar.JYearChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class JMonthChooser
extends JPanel
implements ItemListener,
AdjustmentListener {
    public static final int RIGHT_SPINNER = 0;
    public static final int LEFT_SPINNER = 1;
    public static final int NO_SPINNER = 2;
    private Locale locale;
    private int month;
    private int oldScrollBarValue = 0;
    private JDayChooser dayChooser = null;
    private JYearChooser yearChooser = null;
    private JComboBox comboBox;
    private boolean initialized = false;
    private boolean localInitialize = false;

    public JMonthChooser() {
        this(0);
    }

    public JMonthChooser(int i) {
        this.setLayout(new BorderLayout());
        this.comboBox = new JComboBox();
        this.comboBox.addItemListener(this);
        this.dayChooser = null;
        this.locale = Locale.getDefault();
        this.initNames();
        this.add((Component)this.comboBox, "Center");
        if (i != 2) {
            JScrollBar jscrollbar = new JScrollBar(1, 0, 0, -10000, 10000);
            jscrollbar.setPreferredSize(new Dimension(jscrollbar.getPreferredSize().width, this.getPreferredSize().height));
            jscrollbar.setVisibleAmount(0);
            jscrollbar.addAdjustmentListener(this);
            if (i == 0) {
                this.add((Component)jscrollbar, "East");
            } else {
                this.add((Component)jscrollbar, "West");
            }
        }
        this.initialized = true;
        this.setMonth(Calendar.getInstance().get(2));
    }

    public void initNames() {
        this.localInitialize = true;
        DateFormatSymbols dateformatsymbols = new DateFormatSymbols(this.locale);
        String[] as = dateformatsymbols.getMonths();
        if (this.comboBox.getItemCount() == 12) {
            this.comboBox.removeAllItems();
        }
        for (int i = 0; i < 12; ++i) {
            this.comboBox.addItem(as[i]);
        }
        this.localInitialize = false;
        this.comboBox.setSelectedIndex(this.month);
    }

    @Override
    public void itemStateChanged(ItemEvent itemevent) {
        int i = this.comboBox.getSelectedIndex();
        if (i >= 0) {
            this.setMonth(i, false);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentevent) {
        boolean flag = true;
        int i = adjustmentevent.getValue();
        if (i > this.oldScrollBarValue) {
            flag = false;
        }
        this.oldScrollBarValue = i;
        int j = this.getMonth();
        if (flag) {
            if (++j == 12) {
                j = 0;
                if (this.yearChooser != null) {
                    int k = this.yearChooser.getYear();
                    this.yearChooser.setYear(++k);
                }
            }
        } else if (--j == -1) {
            j = 11;
            if (this.yearChooser != null) {
                int l = this.yearChooser.getYear();
                this.yearChooser.setYear(--l);
            }
        }
        this.setMonth(j);
    }

    private void setMonth(int i, boolean flag) {
        if (this.initialized && !this.localInitialize) {
            int j = this.month;
            this.month = i;
            if (flag) {
                this.comboBox.setSelectedIndex(this.month);
            }
            if (this.dayChooser != null) {
                this.dayChooser.setMonth(this.month);
            }
            this.firePropertyChange("month", j, this.month);
        }
    }

    public void setMonth(int i) {
        this.setMonth(i, true);
    }

    public int getMonth() {
        return this.month;
    }

    public void setDayChooser(JDayChooser jdaychooser) {
        this.dayChooser = jdaychooser;
    }

    public void setYearChooser(JYearChooser jyearchooser) {
        this.yearChooser = jyearchooser;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale1) {
        if (!this.initialized) {
            super.setLocale(locale1);
        } else {
            this.locale = locale1;
            this.initNames();
        }
    }

    public static void main(String[] args) {
        JFrame jframe = new JFrame("MonthChooser");
        jframe.getContentPane().add(new JMonthChooser());
        jframe.pack();
        jframe.setVisible(true);
    }
}

