/*
 * Decompiled with CFR 0.152.
 */
package calendar2.gnu.gui.datepicker;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IntegerDocument
extends PlainDocument {
    private int maxVal;

    public IntegerDocument(int maxValue) {
        if (maxValue > 0) {
            this.maxVal = maxValue;
        }
    }

    public IntegerDocument() {
        this.maxVal = -1;
    }

    @Override
    public void insertString(int index, String s, AttributeSet a) throws BadLocationException {
        boolean noval = false;
        if (s != null && s.length() != 0) {
            block4: {
                StringBuffer t = new StringBuffer(this.getLength() + s.length());
                t.append(this.getText(0, index));
                t.append(s);
                t.append(this.getText(index, this.getLength() - index));
                try {
                    int val = Integer.parseInt(t.toString().trim());
                    if (val > this.maxVal && this.maxVal != -1) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    noval = true;
                    if (!noval) break block4;
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
            }
            super.insertString(index, s, a);
        }
    }
}

