/*
 * Decompiled with CFR 0.152.
 */
package calendar2.gnu.gui.datepicker;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.swing.JTextField;

public class JDateTextField
extends JTextField {
    public String Format = "";
    public static final int CURRENT_DATE = 0;
    public static final int BLANKS = 1;
    public static final int UNDERSCORES = 2;
    public static final int YEAR = 3;
    private static final int BACKSPACE = 8;
    private static final int DELETE = 127;
    private static final int PASTE = 22;
    private static final int CUT = 24;
    private int nDefaultType;
    private boolean bAllowNull;
    private boolean warningMessageActive;

    public void allowNullDate(boolean bAuthorizeNullDate) {
        this.bAllowNull = bAuthorizeNullDate;
    }

    public void setDefaultType(int i) {
        if (i == 1) {
            this.nDefaultType = 1;
            super.setText("  /  /    ");
        } else if (i == 2) {
            this.nDefaultType = 2;
            super.setText("__/__/____");
        } else if (i == 3) {
            this.nDefaultType = 3;
            super.setText("0000");
        } else {
            this.nDefaultType = 0;
            Calendar calendar = Calendar.getInstance();
            super.setText(this.createDateString(calendar.get(5), calendar.get(2) + 1, calendar.get(1)));
        }
    }

    public int getDefaultType() {
        return this.nDefaultType;
    }

    public void setDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        super.setText(this.Format(this.createDateString(calendar.get(5), calendar.get(2) + 1, calendar.get(1))));
    }

    public void setFormat(String Format2) {
        this.Format = Format2;
    }

    public String Format(String Cad) {
        String Date2 = "";
        if (this.Format.equals("dd/MM/yyyy")) {
            Date2 = Cad;
        }
        if (this.Format.equals("MM/dd/yyyy")) {
            Date2 = Cad.substring(3, 5) + "/" + Cad.substring(0, 2) + "/" + Cad.substring(6, 10);
        }
        if (this.Format.equals("yyyy/MM/dd")) {
            Date2 = Cad.substring(6, 10) + "/" + Cad.substring(3, 5) + "/" + Cad.substring(0, 2);
        }
        return Date2;
    }

    public void setText(Date date) {
        this.setDate(date);
    }

    @Override
    public void setText(String s) {
        Date date = null;
        if (s != null) {
            ParsePosition parseposition = new ParsePosition(0);
            if (this.nDefaultType == 3) {
                SimpleDateFormat simpledateformat = new SimpleDateFormat("yyyy");
                date = simpledateformat.parse(s, parseposition);
            } else {
                SimpleDateFormat simpledateformat1 = new SimpleDateFormat("yyyy/MM/dd");
                date = simpledateformat1.parse(s, parseposition);
            }
        }
        if (date == null) {
            super.setText("");
            return;
        }
        this.setDate(date);
    }

    public String getDateText() {
        Date dDate = this.getDate();
        if (dDate == null) {
            return "";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.getDate());
        return this.createDateString(calendar.get(5), calendar.get(2) + 1, calendar.get(1));
    }

    @Override
    public String toString() {
        return this.getText();
    }

    public boolean isEmptyDate() {
        String sCurrentText = super.getText();
        if (sCurrentText.compareTo("  /  /    ") == 0) {
            return true;
        }
        return sCurrentText.compareTo("__/__/____") == 0;
    }

    public Date getDate() throws NumberFormatException {
        Calendar calendar = Calendar.getInstance();
        String sTmp = "";
        int nYear = 2002;
        int nMonth = 1;
        int nDay = 1;
        int[] ai = new int[]{1, 3, 5, 7, 8, 10, 12};
        String sCurrentText = super.getText();
        if (this.bAllowNull && this.isEmptyDate()) {
            return null;
        }
        Vector<Integer> vector = new Vector<Integer>(7);
        for (int l = 0; l < ai.length; ++l) {
            vector.addElement(new Integer(ai[l]));
        }
        calendar.set(nYear, nMonth, nDay, 12, 0, 0);
        try {
            NumberFormatException numberformatexception1 = new NumberFormatException(new String("La date " + sCurrentText + " est invalide\n Le format doit \u00eatre au format DD/MM/YYYY"));
            if (this.nDefaultType == 3) {
                Date date;
                nYear = Integer.parseInt(sCurrentText);
                calendar.set(nYear, 0, 1, 12, 0, 0);
                Date date1 = date = calendar.getTime();
                return date1;
            }
            if (this.Format.equals("dd/MM/yyyy")) {
                sTmp = JDateTextField.replaceString(sCurrentText.substring(0, 2).trim(), "_", "");
                nDay = Integer.parseInt(sTmp);
                sTmp = JDateTextField.replaceString(sCurrentText.substring(3, 5).trim(), "_", "");
                nMonth = Integer.parseInt(sTmp);
                sTmp = JDateTextField.replaceString(sCurrentText.substring(6).trim(), "_", "");
            }
            if (this.Format.equals("MM/dd/yyyy")) {
                sTmp = JDateTextField.replaceString(sCurrentText.substring(3, 5).trim(), "_", "");
                nDay = Integer.parseInt(sTmp);
                sTmp = JDateTextField.replaceString(sCurrentText.substring(0, 2).trim(), "_", "");
                nMonth = Integer.parseInt(sTmp);
                sTmp = JDateTextField.replaceString(sCurrentText.substring(6).trim(), "_", "");
            }
            if (this.Format.equals("yyyy/MM/dd")) {
                sTmp = JDateTextField.replaceString(sCurrentText.substring(8).trim(), "_", "");
                nDay = Integer.parseInt(sTmp);
                sTmp = JDateTextField.replaceString(sCurrentText.substring(5, 7).trim(), "_", "");
                nMonth = Integer.parseInt(sTmp);
                sTmp = JDateTextField.replaceString(sCurrentText.substring(0, 4).trim(), "_", "");
            }
            if (sTmp.length() == 1) {
                sTmp = "200" + sTmp;
            }
            if (sTmp.length() == 2) {
                sTmp = "20" + sTmp;
            }
            if (sTmp.length() == 3) {
                sTmp = "2" + sTmp;
            }
            nYear = Integer.parseInt(sTmp);
            if (nMonth < 1 || nMonth > 12) {
                throw numberformatexception1;
            }
            if (nDay < 1 || nDay > 31) {
                throw numberformatexception1;
            }
            if (nDay == 31 && !vector.contains(new Integer(nMonth))) {
                throw numberformatexception1;
            }
            if (nDay == 30 && nMonth == 2) {
                throw numberformatexception1;
            }
            if (nDay == 29 && nMonth == 2 && !JDateTextField.isLeapYear(nYear)) {
                throw numberformatexception1;
            }
        }
        catch (IndexOutOfBoundsException indexoutofboundsexception) {
            this.setCaretPosition(0);
            NumberFormatException numberformatexception2 = new NumberFormatException(new String("The date " + sCurrentText + " is invalid\n The format doesn't match with format Day/Month/Year"));
            throw numberformatexception2;
        }
        catch (NumberFormatException numberformatexception) {
            this.setCaretPosition(0);
            NumberFormatException numberformatexception3 = new NumberFormatException(new String("The date " + sCurrentText + "  is invalid\n The format doesn't match with format Day/Month/Year"));
            throw numberformatexception3;
        }
        calendar.set(nYear, nMonth - 1, nDay, 12, 0, 0);
        return calendar.getTime();
    }

    public Calendar getCalendar() throws NumberFormatException {
        Calendar calendar = Calendar.getInstance();
        String sTmp = "";
        int nYear = 2002;
        int nMonth = 1;
        int nDay = 1;
        int[] ai = new int[]{1, 3, 5, 7, 8, 10, 12};
        String sCurrentText = super.getText();
        if (this.bAllowNull && this.isEmptyDate()) {
            return null;
        }
        Vector<Integer> vector = new Vector<Integer>(7);
        for (int l = 0; l < ai.length; ++l) {
            vector.addElement(new Integer(ai[l]));
        }
        calendar.set(nYear, nMonth, nDay, 12, 0, 0);
        try {
            NumberFormatException numberformatexception1 = new NumberFormatException(new String("La date " + sCurrentText + " est invalide\n Le format doit \u00eatre au format DD/MM/YYYY"));
            if (this.nDefaultType == 3) {
                Calendar calendar1;
                nYear = Integer.parseInt(sCurrentText);
                calendar.set(nYear, 0, 1, 12, 0, 0);
                Calendar calendar2 = calendar1 = calendar;
                return calendar2;
            }
            sTmp = JDateTextField.replaceString(sCurrentText.substring(0, 2).trim(), "_", "");
            nDay = Integer.parseInt(sTmp);
            sTmp = JDateTextField.replaceString(sCurrentText.substring(3, 5).trim(), "_", "");
            nMonth = Integer.parseInt(sTmp);
            sTmp = JDateTextField.replaceString(sCurrentText.substring(6).trim(), "_", "");
            if (sTmp.length() == 1) {
                sTmp = "200" + sTmp;
            }
            if (sTmp.length() == 2) {
                sTmp = "20" + sTmp;
            }
            if (sTmp.length() == 3) {
                sTmp = "2" + sTmp;
            }
            nYear = Integer.parseInt(sTmp);
            if (nMonth < 1 || nMonth > 12) {
                throw numberformatexception1;
            }
            if (nDay < 1 || nDay > 31) {
                throw numberformatexception1;
            }
            if (nDay == 31 && !vector.contains(new Integer(nMonth))) {
                throw numberformatexception1;
            }
            if (nDay == 30 && nMonth == 2) {
                throw numberformatexception1;
            }
            if (nDay == 29 && nMonth == 2 && !JDateTextField.isLeapYear(nYear)) {
                throw numberformatexception1;
            }
        }
        catch (IndexOutOfBoundsException indexoutofboundsexception) {
            this.setCaretPosition(0);
            NumberFormatException numberformatexception2 = new NumberFormatException(new String("The date " + sCurrentText + " is invalid\n the format doesn't match with format Day/Month/Year"));
            throw numberformatexception2;
        }
        catch (NumberFormatException numberformatexception) {
            this.setCaretPosition(0);
            NumberFormatException numberformatexception3 = new NumberFormatException(new String("The date " + sCurrentText + " is invalid\n the format doesn't match with format Day/Month/Year"));
            throw numberformatexception3;
        }
        calendar.set(nYear, nMonth - 1, nDay, 12, 0, 0);
        return calendar;
    }

    @Override
    public void processKeyEvent(KeyEvent keyevent) {
        String s = "";
        String s2 = "";
        int c = keyevent.getKeyChar();
        boolean flag = false;
        boolean flag1 = false;
        boolean flag2 = false;
        boolean flag3 = false;
        boolean flag4 = false;
        int byte0 = 1;
        boolean flag5 = false;
        boolean flag6 = false;
        boolean flag7 = false;
        boolean flag8 = false;
        boolean flag9 = false;
        flag5 = c == 8;
        flag6 = c == 127;
        flag7 = c == 22;
        flag8 = c == 24;
        flag9 = keyevent.paramString().startsWith("KEY_PRESSED");
        if (keyevent.getKeyCode() == 0 || flag5 || flag6 || flag7 || flag8) {
            if (this.isValidCharacter((char)c)) {
                if (this.isPrintableCharacter((char)c) || flag5 || flag6) {
                    if (!flag5 && !flag6 || flag9) {
                        int l;
                        String s1 = super.getText();
                        int i = s1.length();
                        char[] ac = new char[i];
                        int j = this.getCaretPosition();
                        int k = this.getSelectionStart();
                        if (k != (l = this.getSelectionEnd())) {
                            int i1 = k;
                            this.setSelectionEnd(i1);
                            j = k;
                            this.setCaretPosition(j);
                        }
                        if (!(j > i || j == 0 && flag5 || j == i && !flag5)) {
                            int c1;
                            int j1 = j;
                            if (flag5) {
                                byte0 = -1;
                                j1 += byte0;
                            }
                            if (this.nDefaultType != 3) {
                                c1 = flag6 || flag5 ? (this.nDefaultType == 2 ? 95 : 32) : c;
                            } else {
                                int n = c1 = flag6 || flag5 ? 48 : (int)c;
                            }
                            if (s1.charAt(j1) == '/') {
                                j1 += byte0;
                            }
                            for (int k1 = 0; k1 < i; ++k1) {
                                ac[k1] = k1 == j1 ? c1 : s1.charAt(k1);
                            }
                            String s3 = new String(ac);
                            if (this.isValidString(s3)) {
                                super.setText(s3);
                                if (flag5) {
                                    this.setCaretPosition(j1);
                                } else {
                                    this.setCaretPosition(j1 + 1);
                                }
                            }
                        }
                    }
                    keyevent.consume();
                } else if (flag8 || flag7) {
                    keyevent.consume();
                }
            } else {
                keyevent.consume();
            }
        }
        super.processKeyEvent(keyevent);
    }

    private static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    private boolean isValidCharacter(char c) {
        return !(c >= '!' && c <= '/' || c >= ':' && c <= '~');
    }

    private boolean isPrintableCharacter(char c) {
        return c >= ' ' && c <= '~';
    }

    private boolean isValidDate(int nDay, int nMonth, int nYear) {
        return true;
    }

    private boolean isValidString(String s) {
        return true;
    }

    private String createDateString(int nDay, int nMonth, int nYear) {
        String s = "";
        if (this.isValidDate(nDay, nMonth, nYear)) {
            if (this.nDefaultType != 3) {
                if (nDay < 10) {
                    s = "0";
                }
                s = s + String.valueOf(nDay);
                s = s + "/";
                if (nMonth < 10) {
                    s = s + "0";
                }
                s = s + String.valueOf(nMonth);
                s = s + "/";
            }
            if (nYear < 1000) {
                s = s + "0";
                if (nYear < 100) {
                    s = s + "0";
                    if (nYear < 10) {
                        s = s + "0";
                    }
                }
            }
            s = s + String.valueOf(nYear);
        } else if (this.nDefaultType == 3) {
            s = "2002";
        }
        return s;
    }

    private void validateDateString(FocusEvent focusevent) {
        if (!this.warningMessageActive) {
            try {
                Date dDate = this.getDate();
                if (dDate != null) {
                    this.setDate(dDate);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private static String replaceString(String sSearched, String sFind, String sReplace) {
        String sReplaced = sSearched;
        if (sReplaced != null && sReplaced.length() > 0) {
            int nPos = 0;
            int nFrom = 0;
            while ((nPos = sReplaced.indexOf(sFind, nFrom)) != -1) {
                sReplaced = sReplaced.substring(0, nPos) + sReplace + sReplaced.substring(nPos + sFind.length());
                nFrom = nPos + sReplace.length();
            }
        }
        return sReplaced;
    }

    public JDateTextField(String s) {
        super.setText(s);
    }

    public JDateTextField() {
        this(1, 1, 2002, 0);
        Calendar calendar = Calendar.getInstance();
        super.setText(this.createDateString(calendar.get(5), calendar.get(2) + 1, calendar.get(1)));
    }

    public JDateTextField(int nDay, int nMonth, int nYear) {
        this(nDay, nMonth, nYear, 0);
    }

    public JDateTextField(int i) {
        this(1, 1, 2002, i);
        Calendar calendar = Calendar.getInstance();
        super.setText(this.createDateString(calendar.get(5), calendar.get(2) + 1, calendar.get(1)));
    }

    public JDateTextField(int nDay, int nMonth, int nYear, int l) {
        super("", l);
        this.bAllowNull = true;
        this.nDefaultType = 0;
        this.warningMessageActive = false;
        super.setText(this.createDateString(nDay, nMonth, nYear));
        this.addFocusListener(new _cls1(null));
    }

    private class _cls1
    extends FocusAdapter {
        @Override
        public void focusGained(FocusEvent focusevent) {
            if (JDateTextField.this.isEmptyDate()) {
                JDateTextField.this.setCaretPosition(0);
            }
        }

        @Override
        public void focusLost(FocusEvent focusevent) {
            if (!focusevent.isTemporary()) {
                JDateTextField.this.validateDateString(focusevent);
            }
        }

        private final void constructor$0(JDateTextField jdatetextfield) {
        }

        private void _cls1() {
            this.constructor$0(JDateTextField.this);
        }

        _cls1() {
        }

        _cls1(_cls1 x1) {
            this();
        }
    }
}

