/*
 * Decompiled with CFR 0.152.
 */
package calendar2.gnu.gui.datepicker;

import calendar2.gnu.gui.datepicker.JDateTextField;
import calendar2.gnu.gui.datepicker.JDialogDatePicker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class JPanelDatePicker
extends JPanel
implements Serializable {
    public String Format = "";
    protected JDialogDatePicker datePicker;
    protected JDateTextField textField;
    protected JDateTextField textFieldNew;
    protected Date oldDate;
    protected String message;
    public static final String[] months = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
    public static final String PROP_LABEL_SIZE = "labelSize";
    public static final String PROP_BUTTON_SIZE = "buttonSize";
    public static final String PROP_TEXT_SIZE = "textSize";
    public static final String PROP_LABEL_TEXT = "labelText";
    public static final String PROP_BUTTON_ENABLED = "buttonEnabled";
    public static final String PROP_TEXT_ENABLED = "textEnabled";
    public static final String PROP_BUTTON_DISABLED = "buttonDisabled";
    public static final String PROP_TEXT_DISABLED = "textDisabled";
    public static final String PROP_BUTTON_VISIBLE = "buttonVisible";
    public static final String PROP_TEXT_VISIBLE = "textVisible";
    public static final String PROP_LABEL_VISIBLE = "labelVisible";
    public static final String PROP_BUTTON_INVISIBLE = "buttonInvisible";
    public static final String PROP_TEXT_INVISIBLE = "textInvisible";
    public static final String PROP_LABEL_FONT = "labelFont";
    public static final String PROP_TEXT_FONT = "textFont";
    public static final String PROP_DAY = "day";
    public static final String PROP_MONTH = "month";
    public static final String PROP_YEAR = "year";
    public static final String PROP_CALENDAR = "calendar";
    private PropertyChangeSupport propertySupport;
    public JButton jButton1;
    public JLabel jLabelDateString;

    public JPanelDatePicker(String Format2) {
        this.Format = Format2;
        this.oldDate = new Date();
        this.message = new String("Date");
        this.initComponents();
        this.textField = new JDateTextField("");
        this.textField.setPreferredSize(new Dimension(4, 18));
        this.textField.setDefaultType(2);
        this.textField.allowNullDate(false);
        this.textField.setFormat(Format2);
        this.textField.setFont(new Font("Dialog", 1, 10));
        String cadena = this.textField.getText();
        this.textField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent evt) {
                JPanelDatePicker.this.updateLabelText();
            }

            @Override
            public void focusGained(FocusEvent evt) {
                JPanelDatePicker.this.textField.setCaretPosition(0);
            }
        });
        this.textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelDatePicker.this.jButton1ActionPerformed(evt);
            }
        });
        this.textField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent evt) {
                switch (evt.getKeyCode()) {
                    case 38: {
                        JPanelDatePicker.this.increaseDate();
                        break;
                    }
                    case 40: {
                        JPanelDatePicker.this.decreaseDate();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent keyevent1) {
            }

            @Override
            public void keyTyped(KeyEvent keyevent1) {
            }
        });
        this.datePicker = new JDialogDatePicker(this);
        this.textField = new JDateTextField("");
        this.textField.setFormat(Format2);
        this.add((Component)this.textField, "Center");
        this.propertySupport = new PropertyChangeSupport(this);
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jLabelDateString = new JLabel();
        this.setLayout(new BorderLayout());
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/calendar2/gnu/gui/datepicker/calendar_31.png")));
        this.jButton1.setPreferredSize(new Dimension(25, 25));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelDatePicker.this.jButton1ActionPerformed(evt);
            }
        });
        this.add((Component)this.jButton1, "East");
        this.jLabelDateString.setFont(new Font("Default", 0, 10));
        this.jLabelDateString.setPreferredSize(new Dimension(130, 20));
        this.add((Component)this.jLabelDateString, "West");
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            if (this.textField.getText().length() == 0) {
                this.textFieldNew = new JDateTextField();
                this.datePicker.setDay(this.textFieldNew.getCalendar().get(5));
                this.datePicker.setMonth(this.textFieldNew.getCalendar().get(2));
                this.datePicker.setYear(this.textFieldNew.getCalendar().get(1));
            } else {
                if (this.Format.equals("MM/dd/yyyy")) {
                    this.datePicker.setDay(Integer.parseInt(this.textField.getText().substring(3, 5)));
                    this.datePicker.setMonth(Integer.parseInt(this.textField.getText().substring(0, 2)) - 1);
                    this.datePicker.setYear(Integer.parseInt(this.textField.getText().substring(6)));
                }
                if (this.Format.equals("dd/MM/yyyy")) {
                    this.datePicker.setDay(Integer.parseInt(this.textField.getText().substring(0, 2)));
                    this.datePicker.setMonth(Integer.parseInt(this.textField.getText().substring(3, 5)) - 1);
                    this.datePicker.setYear(Integer.parseInt(this.textField.getText().substring(6)));
                }
                if (this.Format.equals("yyyy/MM/dd")) {
                    this.datePicker.setDay(Integer.parseInt(this.textField.getText().substring(8)));
                    this.datePicker.setMonth(Integer.parseInt(this.textField.getText().substring(5, 7)) - 1);
                    this.datePicker.setYear(Integer.parseInt(this.textField.getText().substring(0, 4)));
                }
            }
        }
        catch (Exception e) {
            this.showError(e);
        }
        this.datePicker.setLocation(this.jLabelDateString.getLocationOnScreen());
        this.datePicker.setTitle("Select " + this.message);
        this.datePicker.setVisible(true);
    }

    protected void increaseDate() {
        try {
            Calendar calendar = this.textField.getCalendar();
            int day = calendar.get(5);
            int month = calendar.get(2);
            int year = calendar.get(1);
            int caretPosition = this.textField.getCaretPosition();
            if (caretPosition >= 0 && caretPosition <= 2) {
                calendar.set(5, day + 1);
            } else if (caretPosition >= 2 && caretPosition <= 5) {
                calendar.set(2, month + 1);
            } else if (caretPosition >= 5) {
                calendar.set(1, year + 1);
            }
            this.setCalendar(calendar);
            this.textField.setCaretPosition(caretPosition);
            if (caretPosition >= 0 && caretPosition <= 2) {
                this.textField.select(0, 2);
            } else if (caretPosition >= 2 && caretPosition <= 5) {
                this.textField.select(3, 5);
            } else if (caretPosition >= 5) {
                this.textField.select(6, 10);
            }
            this.updateLabelText();
        }
        catch (Exception e) {
            this.showError(e);
        }
    }

    protected void decreaseDate() {
        try {
            Calendar calendar = this.textField.getCalendar();
            int caretPosition = this.textField.getCaretPosition();
            int day = calendar.get(5);
            int month = calendar.get(2);
            int year = calendar.get(1);
            if (caretPosition >= 0 && caretPosition <= 2) {
                calendar.set(5, day - 1);
            } else if (caretPosition >= 2 && caretPosition <= 5) {
                calendar.set(2, month - 1);
            } else if (caretPosition >= 5) {
                calendar.set(1, year - 1);
            }
            this.setCalendar(calendar);
            this.textField.setCaretPosition(caretPosition);
            if (caretPosition >= 0 && caretPosition <= 2) {
                this.textField.select(0, 2);
            } else if (caretPosition >= 2 && caretPosition <= 5) {
                this.textField.select(3, 5);
            } else if (caretPosition >= 5) {
                this.textField.select(6, 10);
            }
            this.updateLabelText();
        }
        catch (Exception e) {
            this.showError(e);
        }
    }

    public int getYear() throws Exception {
        return this.textField.getCalendar().get(1);
    }

    public int getMonth() throws Exception {
        return this.textField.getCalendar().get(2);
    }

    public int getDay() throws Exception {
        return this.textField.getCalendar().get(5);
    }

    public void setYear(int year) throws Exception {
        this.propertySupport.firePropertyChange(PROP_YEAR, this.getYear(), year);
        this.textField.getCalendar().set(1, year);
    }

    public void setMonth(int month) throws Exception {
        this.propertySupport.firePropertyChange(PROP_MONTH, this.getMonth(), month);
        this.textField.getCalendar().set(2, month);
    }

    public void setDay(int day) throws Exception {
        this.propertySupport.firePropertyChange(PROP_DAY, this.getDay(), day);
        this.textField.getCalendar().set(5, day);
    }

    protected void showError(Exception e) {
        this.resetDate();
        JOptionPane.showMessageDialog(this, e.getMessage(), e.getClass().getName(), 0);
    }

    protected void resetDate() {
        this.textField.setDate(this.oldDate);
        this.updateLabelText();
    }

    protected void backupDate() throws Exception {
        this.oldDate = this.textField.getDate();
    }

    protected void updateLabelText() {
        try {
            this.backupDate();
        }
        catch (Exception e) {
            this.showError(e);
        }
    }

    public Calendar getCalendar() throws Exception {
        return this.textField.getCalendar();
    }

    public void setCalendar(Calendar cal) throws Exception {
        this.textField.setDate(cal.getTime());
    }

    public void setMessage(String msg) {
        this.propertySupport.firePropertyChange(PROP_LABEL_TEXT, this.message, msg);
        this.message = msg;
        this.updateLabelText();
    }

    public String getMessage() {
        return this.message;
    }

    public String getText() {
        return this.textField.getText();
    }

    public void setText(String s) {
        this.textField.setText(s);
    }

    public String getLabel() {
        return this.jLabelDateString.getText();
    }

    public Dimension getTextFieldPreferedSize() {
        return this.textField.getPreferredSize();
    }

    public Dimension getButtonPreferedSize() {
        return this.jButton1.getPreferredSize();
    }

    public Dimension getLabelPreferedSize() {
        return this.jLabelDateString.getPreferredSize();
    }

    public void setTextFieldPreferedSize(Dimension newPreferedSize) {
        this.propertySupport.firePropertyChange(PROP_TEXT_SIZE, this.textField.getPreferredSize(), newPreferedSize);
        this.textField.setPreferredSize(newPreferedSize);
    }

    public void setLabelVisible(boolean b) {
        this.propertySupport.firePropertyChange(PROP_LABEL_VISIBLE, this.getLabelVisible(), b);
        this.jLabelDateString.setVisible(b);
    }

    public boolean getLabelVisible() {
        return this.jLabelDateString.isVisible();
    }

    public void setButtonPreferedSize(Dimension newPreferedSize) {
        this.propertySupport.firePropertyChange(PROP_BUTTON_SIZE, this.jButton1.getPreferredSize(), newPreferedSize);
        this.jButton1.setPreferredSize(newPreferedSize);
    }

    public void setLabelPreferedSize(Dimension newPreferedSize) {
        this.propertySupport.firePropertyChange(PROP_LABEL_SIZE, this.jLabelDateString.getPreferredSize(), newPreferedSize);
        this.jLabelDateString.setPreferredSize(newPreferedSize);
    }

    public void setTextFieldPreferedSize(int width, int height) {
        this.setTextFieldPreferedSize(new Dimension(width, height));
    }

    public void setButtonPreferedSize(int width, int height) {
        this.setButtonPreferedSize(new Dimension(width, height));
    }

    public void setLabelPreferedSize(int width, int height) {
        this.setLabelPreferedSize(new Dimension(width, height));
    }

    public void setTextFieldEnabled(boolean enabled) {
        this.propertySupport.firePropertyChange(enabled ? PROP_TEXT_ENABLED : PROP_TEXT_DISABLED, this.getTextFieldEnabled(), enabled);
        this.textField.setEnabled(enabled);
    }

    public void setTextFieldEditable(boolean enabled) {
        this.propertySupport.firePropertyChange(enabled ? "textEditable" : "textNotEditable", this.getTextFieldEditable(), enabled);
        this.textField.setEditable(enabled);
    }

    public void setButtonEnabled(boolean enabled) {
        this.propertySupport.firePropertyChange(enabled ? PROP_BUTTON_ENABLED : PROP_BUTTON_DISABLED, this.getButtonEnabled(), enabled);
        this.jButton1.setEnabled(enabled);
    }

    public void setTextFont(Font f) {
        this.propertySupport.firePropertyChange(PROP_TEXT_FONT, this.getFont(), f);
        this.textField.setFont(f);
    }

    public void setLabelFont(Font f) {
        this.propertySupport.firePropertyChange(PROP_LABEL_FONT, this.getFont(), f);
        this.jLabelDateString.setFont(f);
    }

    public Font getTextFont() {
        return this.textField.getFont();
    }

    public Font getLabelFont() {
        return this.jLabelDateString.getFont();
    }

    public boolean getTextFieldEnabled() {
        return this.textField.isEnabled();
    }

    public boolean getTextFieldEditable() {
        return this.textField.isEditable();
    }

    public boolean getButtonEnabled() {
        return this.jButton1.isEnabled();
    }

    public void setTextFieldVisible(boolean visible) {
        this.propertySupport.firePropertyChange(visible ? PROP_TEXT_VISIBLE : PROP_TEXT_INVISIBLE, this.getTextFieldVisible(), visible);
        this.textField.setVisible(visible);
    }

    public void setButtonVisible(boolean visible) {
        this.propertySupport.firePropertyChange(visible ? PROP_BUTTON_VISIBLE : PROP_BUTTON_INVISIBLE, this.getButtonVisible(), visible);
        this.jButton1.setVisible(visible);
    }

    public boolean getTextFieldVisible() {
        return this.textField.isVisible();
    }

    public boolean getButtonVisible() {
        return this.jButton1.isVisible();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.removePropertyChangeListener(l);
    }

    public String getSabreMonth() throws Exception {
        return months[this.getMonth()];
    }

    public void requestTextFocus() {
        this.textField.requestFocus();
    }

    public void requestButtonFocus() {
        this.jButton1.requestFocus();
    }
}

