/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.AbstractXmlDataSource;
import net.sf.jasperreports.engine.util.xml.JRXmlDocumentProducer;
import net.sf.jasperreports.engine.util.xml.XalanNsAwareXPathExecuter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XalanXmlDataSource
extends AbstractXmlDataSource {
    private Document document;
    private String selectExpression;
    private NodeList nodeList;
    private int nodeListLength;
    private Node currentNode;
    private int currentNodeIndex = -1;
    private final XalanNsAwareXPathExecuter xPathExecuter = new XalanNsAwareXPathExecuter();
    private final JRXmlDocumentProducer documentProducer;
    private boolean mustBeMovedFirst;

    public XalanXmlDataSource(Document document) throws JRException {
        this(document, ".");
    }

    public XalanXmlDataSource(Document document, String selectExpression) throws JRException {
        this.document = document;
        this.selectExpression = selectExpression;
        this.documentProducer = new JRXmlDocumentProducer();
        this.mustBeMovedFirst = true;
    }

    public XalanXmlDataSource(InputStream in) throws JRException {
        this(in, ".");
    }

    public XalanXmlDataSource(InputStream in, String selectExpression) throws JRException {
        this.selectExpression = selectExpression;
        this.documentProducer = new JRXmlDocumentProducer(in);
        this.mustBeMovedFirst = true;
    }

    public XalanXmlDataSource(String uri) throws JRException {
        this(uri, ".");
    }

    public XalanXmlDataSource(String uri, String selectExpression) throws JRException {
        this.selectExpression = selectExpression;
        this.documentProducer = new JRXmlDocumentProducer(uri);
        this.mustBeMovedFirst = true;
    }

    public XalanXmlDataSource(File file) throws JRException {
        this(file, ".");
    }

    public XalanXmlDataSource(File file, String selectExpression) throws JRException {
        this.selectExpression = selectExpression;
        this.documentProducer = new JRXmlDocumentProducer(file);
        this.mustBeMovedFirst = true;
    }

    @Override
    public void moveFirst() throws JRException {
        if (this.document == null) {
            this.document = this.documentProducer.getDocument();
            if (this.document == null) {
                throw new JRException("document cannot be null");
            }
        }
        if (this.selectExpression == null) {
            throw new JRException("selectExpression cannot be null");
        }
        this.currentNode = null;
        this.currentNodeIndex = -1;
        this.nodeListLength = 0;
        this.nodeList = this.xPathExecuter.selectNodeList(this.document, this.selectExpression);
        this.nodeListLength = this.nodeList.getLength();
    }

    @Override
    public boolean next() throws JRException {
        if (this.mustBeMovedFirst) {
            this.moveFirst();
            this.mustBeMovedFirst = false;
        }
        if (this.currentNodeIndex == this.nodeListLength - 1) {
            return false;
        }
        this.currentNode = this.nodeList.item(++this.currentNodeIndex);
        return true;
    }

    @Override
    public Document subDocument() throws JRException {
        if (this.currentNode == null) {
            throw new JRException("No node available. Iterate or rewind the data source.");
        }
        return this.documentProducer.getDocument(this.currentNode);
    }

    public void setXmlNamespaceMap(Map<String, String> xmlNamespaceMap) throws JRException {
        this.xPathExecuter.setXmlNamespaceMap(xmlNamespaceMap);
    }

    public void setDetectXmlNamespaces(boolean detectXmlNamespaces) {
        this.xPathExecuter.setDetectXmlNamespaces(detectXmlNamespaces);
    }

    public void setDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        this.documentProducer.setDocumentBuilderFactory(documentBuilderFactory);
    }

    @Override
    public Node getCurrentNode() {
        return this.currentNode;
    }

    @Override
    public Object getSelectObject(Node currentNode, String expression) throws JRException {
        return this.xPathExecuter.selectObject(currentNode, expression);
    }

    @Override
    public AbstractXmlDataSource subDataSource(String selectExpr) throws JRException {
        Document doc = this.subDocument();
        XalanXmlDataSource subDataSource = new XalanXmlDataSource(doc, selectExpr);
        subDataSource.setTextAttributes(this);
        subDataSource.setXmlNamespaceMap(this.xPathExecuter.getXmlNamespaceMap());
        subDataSource.setDetectXmlNamespaces(this.xPathExecuter.getDetectXmlNamespaces());
        subDataSource.setDocumentBuilderFactory(this.documentProducer.getDocumentBuilderFactory());
        return subDataSource;
    }

    @Override
    public AbstractXmlDataSource dataSource(String selectExpr) throws JRException {
        XalanXmlDataSource subDataSource = new XalanXmlDataSource(this.document, selectExpr);
        subDataSource.setTextAttributes(this);
        subDataSource.setXmlNamespaceMap(this.xPathExecuter.getXmlNamespaceMap());
        subDataSource.setDetectXmlNamespaces(this.xPathExecuter.getDetectXmlNamespaces());
        subDataSource.setDocumentBuilderFactory(this.documentProducer.getDocumentBuilderFactory());
        return subDataSource;
    }
}

