/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseGenericPrintElement;
import net.sf.jasperreports.engine.export.FlashHtmlHandler;
import net.sf.jasperreports.engine.export.GenericElementHandler;
import net.sf.jasperreports.engine.export.GenericElementHandlerBundle;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FlashPrintElement {
    private static final Log log = LogFactory.getLog(FlashPrintElement.class);
    public static final String FLASH_ELEMENT_NAME = "flash";
    public static final JRGenericElementType FLASH_ELEMENT_TYPE = new JRGenericElementType("http://jasperreports.sourceforge.net/jasperreports", "flash");
    public static final String PARAMETER_SWF_URL = "SWF_URL";
    public static final String PARAMETER_FLASH_VAR_PREFIX = "FLASH_VAR_";
    public static final String PROPERTY_IGNORE_SIZE = "net.sf.jasperreports.export.swf.ignore.size";
    public static final String PROPERTY_ALLOW_SCRIPT_ACCESS = "net.sf.jasperreports.export.flash.element.allow.script.access";
    private static final GenericElementHandlerBundle HANDLER_BUNDLE = new GenericElementHandlerBundle(){

        public String getNamespace() {
            return "http://jasperreports.sourceforge.net/jasperreports";
        }

        public GenericElementHandler getHandler(String elementName, String exporterKey) {
            if (FlashPrintElement.FLASH_ELEMENT_NAME.equals(elementName) && "net.sf.jasperreports.html".equals(exporterKey)) {
                return FlashHtmlHandler.getInstance();
            }
            return null;
        }
    };
    protected static final Pattern LINK_PATTERN = Pattern.compile("\\{(link\\-[\\-\\w]+)\\}");
    protected static final int LINK_PARAM_NAME_GROUP = 1;

    public static GenericElementHandlerBundle getHandlerBundle() {
        return HANDLER_BUNDLE;
    }

    public static JRGenericPrintElement makeFlashElement(JRPrintElement template, String swfUrl, Map<String, Object> flashVars, Map<String, Object> elementParameters) {
        Object value;
        String name;
        JRBaseGenericPrintElement flashEl = new JRBaseGenericPrintElement(template.getDefaultStyleProvider());
        flashEl.setX(template.getX());
        flashEl.setY(template.getY());
        flashEl.setWidth(template.getWidth());
        flashEl.setHeight(template.getHeight());
        flashEl.setStyle(template.getStyle());
        flashEl.setMode(template.getOwnModeValue());
        flashEl.setBackcolor(template.getOwnBackcolor());
        flashEl.setForecolor(template.getOwnForecolor());
        flashEl.setOrigin(template.getOrigin());
        flashEl.setKey(template.getKey());
        flashEl.setGenericType(FLASH_ELEMENT_TYPE);
        flashEl.setParameterValue(PARAMETER_SWF_URL, swfUrl);
        for (Map.Entry<String, Object> entry : flashVars.entrySet()) {
            name = entry.getKey();
            value = entry.getValue();
            String paramName = PARAMETER_FLASH_VAR_PREFIX + name;
            flashEl.setParameterValue(paramName, value);
        }
        if (elementParameters != null && !elementParameters.isEmpty()) {
            for (Map.Entry<String, Object> entry : elementParameters.entrySet()) {
                name = entry.getKey();
                value = entry.getValue();
                flashEl.setParameterValue(name, value);
            }
        }
        return flashEl;
    }

    public static String makeLinkParameterName(JRPrintHyperlink hyperlink) {
        return "link-" + System.identityHashCode(hyperlink);
    }

    public static String makeLinkPlaceholder(JRPrintHyperlink hyperlink) {
        String id = FlashPrintElement.makeLinkParameterName(hyperlink);
        return FlashPrintElement.makeLinkPlaceholder(id);
    }

    public static String makeLinkPlaceholder(String linkId) {
        return "{" + linkId + "}";
    }

    public static String resolveLinks(String text, JRGenericPrintElement element, JRHyperlinkProducer linkProducer) {
        Matcher matcher = LINK_PATTERN.matcher(text);
        StringBuffer xml = new StringBuffer();
        while (matcher.find()) {
            String replacement;
            String paramName = matcher.group(1);
            JRPrintHyperlink hyperlink = (JRPrintHyperlink)element.getParameterValue(paramName);
            if (hyperlink == null) {
                if (log.isWarnEnabled()) {
                    log.warn("Hyperlink parameter " + paramName + " not found in element");
                }
                replacement = null;
            } else {
                replacement = linkProducer.getHyperlink(hyperlink);
            }
            if (replacement == null) {
                replacement = "";
            } else {
                try {
                    replacement = URLEncoder.encode(replacement, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new JRRuntimeException(e);
                }
            }
            matcher.appendReplacement(xml, replacement);
        }
        matcher.appendTail(xml);
        return xml.toString();
    }

    private FlashPrintElement() {
    }
}

