/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.base.VirtualElementsData;
import net.sf.jasperreports.engine.fill.ElementEvaluationAction;
import net.sf.jasperreports.engine.fill.EvaluationBoundAction;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JREvaluationTime;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.VirtualizationListener;
import net.sf.jasperreports.engine.fill.VirtualizedPageEvaluationAction;
import net.sf.jasperreports.engine.util.LinkedMap;
import net.sf.jasperreports.engine.util.UniformPrintElementVisitor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ElementEvaluationVirtualizationListener
implements VirtualizationListener<VirtualElementsData> {
    private static final Log log = LogFactory.getLog(ElementEvaluationAction.class);
    private final JRBaseFiller mainFiller;

    public ElementEvaluationVirtualizationListener(JRBaseFiller filler) {
        this.mainFiller = filler;
    }

    @Override
    public void beforeExternalization(JRVirtualizable<VirtualElementsData> object) {
        this.setElementEvaluationsToPage(this.mainFiller, object);
        if (this.mainFiller.subfillers != null) {
            for (JRBaseFiller subfiller : this.mainFiller.subfillers.values()) {
                this.setElementEvaluationsToPage(subfiller, object);
            }
        }
    }

    protected void setElementEvaluationsToPage(final JRBaseFiller filler, final JRVirtualizable<VirtualElementsData> object) {
        VirtualElementsData virtualData = object.getVirtualData();
        for (Map.Entry<JREvaluationTime, LinkedMap<Object, EvaluationBoundAction>> boundMapEntry : filler.boundElements.entrySet()) {
            final JREvaluationTime evaluationTime = boundMapEntry.getKey();
            final LinkedMap<Object, EvaluationBoundAction> map = boundMapEntry.getValue();
            if (map.isEmpty()) continue;
            final LinkedHashMap<JRPrintElement, Integer> elementEvaluations = new LinkedHashMap<JRPrintElement, Integer>();
            UniformPrintElementVisitor<Void> visitor = new UniformPrintElementVisitor<Void>(true){

                @Override
                protected void visitElement(JRPrintElement element, Void arg) {
                    ElementEvaluationAction action = (ElementEvaluationAction)map.remove(element);
                    if (action != null) {
                        elementEvaluations.put(element, action.element.elementId);
                        if (log.isDebugEnabled()) {
                            log.debug("filler " + filler.fillerId + " saving evaluation " + evaluationTime + " of element " + element + " on object " + object);
                        }
                    }
                }
            };
            for (JRPrintElement element : virtualData.getElements()) {
                element.accept(visitor, null);
            }
            if (elementEvaluations.isEmpty()) continue;
            virtualData.setElementEvaluations(filler.fillerId, evaluationTime, elementEvaluations);
            map.add(null, new VirtualizedPageEvaluationAction(object));
        }
    }

    @Override
    public void afterInternalization(JRVirtualizable<VirtualElementsData> object) {
        this.getElementEvaluationsFromPage(this.mainFiller, object);
        if (this.mainFiller.subfillers != null) {
            for (JRBaseFiller subfiller : this.mainFiller.subfillers.values()) {
                this.getElementEvaluationsFromPage(subfiller, object);
            }
        }
    }

    protected void getElementEvaluationsFromPage(JRBaseFiller filler, JRVirtualizable<VirtualElementsData> object) {
        VirtualElementsData elementsData = object.getVirtualData();
        for (Map.Entry<JREvaluationTime, LinkedMap<Object, EvaluationBoundAction>> boundMapEntry : filler.boundElements.entrySet()) {
            JREvaluationTime evaluationTime = boundMapEntry.getKey();
            LinkedMap<Object, EvaluationBoundAction> map = boundMapEntry.getValue();
            Map<JRPrintElement, Integer> elementEvaluations = elementsData.getElementEvaluations(filler.fillerId, evaluationTime);
            if (elementEvaluations == null) continue;
            for (Map.Entry<JRPrintElement, Integer> entry : elementEvaluations.entrySet()) {
                JRPrintElement element = entry.getKey();
                int fillElementId = entry.getValue();
                JRFillElement fillElement = filler.fillElements.get(fillElementId);
                if (log.isDebugEnabled()) {
                    log.debug("filler " + filler.fillerId + " got evaluation " + evaluationTime + " on " + element + " from object " + object + ", using " + fillElement);
                }
                if (fillElement == null) {
                    throw new JRRuntimeException("Fill element with id " + fillElementId + " not found");
                }
                map.addFirst(element, new ElementEvaluationAction(fillElement, element));
            }
        }
    }
}

