/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.Deduplicable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeduplicableRegistry {
    private static final Log log = LogFactory.getLog(DeduplicableRegistry.class);
    private final Map<Class<? extends Deduplicable>, DeduplicableMap<?>> typesMap = new HashMap();

    public <T extends Deduplicable> T deduplicate(T object) {
        DeduplicableMap<T> typeMap = this.typeMap(object);
        return typeMap.deduplicate(object);
    }

    protected <T extends Deduplicable> DeduplicableMap<T> typeMap(T object) {
        DeduplicableMap<Object> typeMap = this.typesMap.get(object.getClass());
        if (typeMap == null) {
            typeMap = new DeduplicableMap();
            this.typesMap.put(object.getClass(), typeMap);
        }
        return typeMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DeduplicableMap<T extends Deduplicable> {
        private final Map<DeduplicableWrapper<T>, T> objects = new HashMap<DeduplicableWrapper<T>, T>();

        protected DeduplicableMap() {
        }

        public T deduplicate(T object) {
            DeduplicableWrapper<T> key = new DeduplicableWrapper<T>(object);
            Deduplicable existing = (Deduplicable)this.objects.get(key);
            if (existing == null) {
                this.objects.put(key, object);
                existing = object;
                if (log.isDebugEnabled()) {
                    log.debug("Added object " + object);
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Found existing instance " + existing + " for object " + object);
            }
            return (T)existing;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DeduplicableWrapper<T extends Deduplicable> {
        private final T object;
        private final int hash;

        public DeduplicableWrapper(T object) {
            this.object = object;
            this.hash = object.getHashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object other) {
            return this.object.isIdentical(((DeduplicableWrapper)other).object);
        }
    }
}

