/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRSwapFile {
    private static final Log log = LogFactory.getLog(JRSwapFile.class);
    public static final String PROPERTY_DELETE_ON_EXIT = "net.sf.jasperreports.virtualizer.files.delete.on.exit";
    private final File swapFile;
    protected final RandomAccessFile file;
    private final int blockSize;
    private final int minGrowCount;
    private final LongQueue freeBlocks;

    public JRSwapFile(String directory, int blockSize, int minGrowCount) {
        try {
            String filename = "swap_" + System.identityHashCode(this) + "_" + System.currentTimeMillis();
            this.swapFile = new File(directory, filename);
            if (log.isDebugEnabled()) {
                log.debug("Creating swap file " + this.swapFile.getPath());
            }
            boolean fileExists = this.swapFile.exists();
            if (JRProperties.getBooleanProperty(PROPERTY_DELETE_ON_EXIT)) {
                this.swapFile.deleteOnExit();
            }
            this.file = new RandomAccessFile(this.swapFile, "rw");
            this.blockSize = blockSize;
            this.minGrowCount = minGrowCount;
            this.freeBlocks = new LongQueue(minGrowCount);
            if (fileExists) {
                this.file.setLength(0L);
                if (log.isDebugEnabled()) {
                    log.debug("Swap file " + this.swapFile.getPath() + " exists, truncating");
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new JRRuntimeException(e);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public SwapHandle write(byte[] data) throws IOException {
        int blockCount = (data.length - 1) / this.blockSize + 1;
        long[] offsets = this.reserveFreeBlocks(blockCount);
        int lastBlockSize = (data.length - 1) % this.blockSize + 1;
        SwapHandle handle = new SwapHandle(offsets, lastBlockSize);
        for (int i = 0; i < blockCount; ++i) {
            int dataSize = i < blockCount - 1 ? this.blockSize : lastBlockSize;
            int dataOffset = i * this.blockSize;
            this.write(data, dataSize, dataOffset, offsets[i]);
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(byte[] data, int dataSize, int dataOffset, long fileOffset) throws IOException {
        JRSwapFile jRSwapFile = this;
        synchronized (jRSwapFile) {
            this.file.seek(fileOffset);
            this.file.write(data, dataOffset, dataSize);
        }
    }

    public byte[] read(SwapHandle handle, boolean free) throws IOException {
        long[] offsets = handle.getOffsets();
        int totalLength = (offsets.length - 1) * this.blockSize + handle.getLastSize();
        byte[] data = new byte[totalLength];
        for (int i = 0; i < offsets.length; ++i) {
            int dataOffset = i * this.blockSize;
            int dataLength = i < offsets.length - 1 ? this.blockSize : handle.getLastSize();
            this.read(data, dataOffset, dataLength, offsets[i]);
        }
        if (free) {
            this.freeBlocks(offsets);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void read(byte[] data, int dataOffset, int dataLength, long fileOffset) throws IOException {
        JRSwapFile jRSwapFile = this;
        synchronized (jRSwapFile) {
            this.file.seek(fileOffset);
            this.file.readFully(data, dataOffset, dataLength);
        }
    }

    public void free(SwapHandle handle) {
        this.freeBlocks(handle.getOffsets());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        JRSwapFile jRSwapFile = this;
        synchronized (jRSwapFile) {
            if (this.swapFile.exists()) {
                if (log.isDebugEnabled()) {
                    log.debug("Disposing swap file " + this.swapFile.getPath());
                }
                try {
                    this.file.close();
                }
                catch (IOException e) {
                    log.warn("Not able to close swap file " + this.swapFile.getPath());
                }
                if (!this.swapFile.delete()) {
                    log.warn("Not able to delete swap file " + this.swapFile.getPath());
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    protected synchronized long[] reserveFreeBlocks(int blockCount) throws IOException {
        int growCount = blockCount - this.freeBlocks.size();
        if (growCount > 0) {
            if (growCount < this.minGrowCount) {
                growCount = this.minGrowCount;
            }
            long length = this.file.length();
            long newLength = length + (long)(growCount * this.blockSize);
            if (log.isDebugEnabled()) {
                log.debug("Growing swap file " + this.swapFile.getPath() + " with " + growCount + " blocks x " + this.blockSize + " bytes to size " + newLength);
            }
            this.file.setLength(newLength);
            for (int i = 0; i < growCount; ++i) {
                this.freeBlocks.addLast(length + (long)(i * this.blockSize));
            }
        }
        long[] offsets = new long[blockCount];
        for (int i = 0; i < blockCount; ++i) {
            offsets[i] = this.freeBlocks.popFirst();
        }
        return offsets;
    }

    protected synchronized void freeBlocks(long[] offsets) {
        for (int i = offsets.length - 1; i >= 0; --i) {
            this.freeBlocks.addFirst(offsets[i]);
        }
    }

    public static class SwapHandle {
        private final long[] offsets;
        private final int lastSize;

        public SwapHandle(long[] offsets, int lastSize) {
            this.offsets = offsets;
            this.lastSize = lastSize;
        }

        public long[] getOffsets() {
            return this.offsets;
        }

        public int getLastSize() {
            return this.lastSize;
        }
    }

    protected static class LongQueue {
        private final int minGrowCount;
        private long[] vals;
        private int size;
        private int first;
        private int last;

        public LongQueue(int minGrowCount) {
            this.minGrowCount = minGrowCount;
            this.vals = new long[minGrowCount];
            this.size = 0;
            this.first = 0;
            this.last = 0;
        }

        public void addFirst(long val) {
            this.growIfFull();
            --this.first;
            if (this.first == -1) {
                this.first = this.vals.length - 1;
            }
            this.vals[this.first] = val;
            ++this.size;
        }

        public void addLast(long val) {
            this.growIfFull();
            this.vals[this.last] = val;
            ++this.size;
            ++this.last;
            if (this.last == this.vals.length) {
                this.last = 0;
            }
        }

        public long popFirst() {
            if (this.size == 0) {
                throw new JRRuntimeException("Queue underflow");
            }
            long val = this.vals[this.first];
            ++this.first;
            if (this.first == this.vals.length) {
                this.first = 0;
            }
            --this.size;
            return val;
        }

        protected void growIfFull() {
            int valsLength = this.vals.length;
            if (this.size == valsLength) {
                int newLength = valsLength * 3 / 2 + 1;
                if (newLength - valsLength < this.minGrowCount) {
                    newLength = valsLength + this.minGrowCount;
                }
                long[] newVals = new long[newLength];
                System.arraycopy(this.vals, this.first, newVals, 0, valsLength - this.first);
                if (this.last > 0) {
                    System.arraycopy(this.vals, 0, newVals, valsLength - this.first, this.last);
                }
                this.vals = newVals;
                this.first = 0;
                this.last = valsLength;
            }
        }

        public int size() {
            return this.size;
        }
    }
}

