/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.extensions;

import java.net.URL;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.extensions.ExtensionsRegistry;
import net.sf.jasperreports.extensions.ExtensionsRegistryFactory;
import net.sf.jasperreports.extensions.SpringExtensionsRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class SpringExtensionsRegistryFactory
implements ExtensionsRegistryFactory {
    private static final Log log = LogFactory.getLog(SpringExtensionsRegistryFactory.class);
    public static final String PROPERTY_SUFFIX_SPRING_BEANS_RESOURCE = ".spring.beans.resource";

    public ExtensionsRegistry createRegistry(String registryId, JRPropertiesMap properties) {
        ListableBeanFactory beanFactory = this.getBeanFactory(registryId, properties);
        return new SpringExtensionsRegistry(beanFactory);
    }

    protected ListableBeanFactory getBeanFactory(String registryId, JRPropertiesMap properties) {
        String resourceProp = "net.sf.jasperreports.extension." + registryId + PROPERTY_SUFFIX_SPRING_BEANS_RESOURCE;
        String resource = properties.getProperty(resourceProp);
        if (resource == null) {
            throw new JRRuntimeException("No Spring resource property set");
        }
        URL resourceLocation = JRLoader.getResource(resource);
        if (resourceLocation == null) {
            throw new JRRuntimeException("Could not find Spring resource " + resource + " for extensions registry " + registryId);
        }
        if (log.isDebugEnabled()) {
            log.debug("Creating Spring beans factory for extensions registry " + registryId + " using " + resourceLocation);
        }
        return new XmlBeanFactory((Resource)new UrlResource(resourceLocation));
    }
}

