/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JRViewer;

public class JasperViewerDialog
extends JDialog {
    private JRViewer viewer = null;
    private boolean isExitOnClose = true;
    private JPanel pnlMain;

    public JasperViewerDialog(String sourceFile, boolean isXMLFile) throws JRException {
        this(sourceFile, isXMLFile, true);
    }

    public JasperViewerDialog(InputStream is, boolean isXMLFile) throws JRException {
        this(is, isXMLFile, true);
    }

    public JasperViewerDialog(JasperPrint jasperPrint) {
        this(jasperPrint, true);
    }

    public JasperViewerDialog(String sourceFile, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        this(sourceFile, isXMLFile, isExitOnClose, null);
    }

    public JasperViewerDialog(InputStream is, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        this(is, isXMLFile, isExitOnClose, null);
    }

    public JasperViewerDialog(JasperPrint jasperPrint, boolean isExitOnClose) {
        this(jasperPrint, isExitOnClose, null);
    }

    public JasperViewerDialog(String sourceFile, boolean isXMLFile, boolean isExitOnClose, Locale locale) throws JRException {
        super(new Frame(), "", true);
        if (locale != null) {
            this.setLocale(locale);
        }
        this.isExitOnClose = isExitOnClose;
        this.initComponents();
        this.viewer = new JRViewer(sourceFile, isXMLFile, locale);
        this.pnlMain.add((Component)this.viewer, "Center");
    }

    public JasperViewerDialog(InputStream is, boolean isXMLFile, boolean isExitOnClose, Locale locale) throws JRException {
        super(new Frame(), "", true);
        if (locale != null) {
            this.setLocale(locale);
        }
        this.isExitOnClose = isExitOnClose;
        this.initComponents();
        this.viewer = new JRViewer(is, isXMLFile, locale);
        this.pnlMain.add((Component)this.viewer, "Center");
    }

    public JasperViewerDialog(JasperPrint jasperPrint, boolean isExitOnClose, Locale locale) {
        super(new Frame(), "", true);
        if (locale != null) {
            this.setLocale(locale);
        }
        this.isExitOnClose = isExitOnClose;
        this.initComponents();
        this.viewer = new JRViewer(jasperPrint, locale);
        this.pnlMain.add((Component)this.viewer, "Center");
    }

    private void initComponents() {
        int width;
        this.pnlMain = new JPanel();
        this.setTitle("Reporte");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                JasperViewerDialog.this.exitForm();
            }
        });
        this.pnlMain.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.pnlMain, "Center");
        this.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int screenResolution = toolkit.getScreenResolution();
        float zoom = (float)screenResolution / 72.0f;
        int height = (int)(550.0f * zoom);
        if ((double)height > screenSize.getHeight()) {
            height = (int)screenSize.getHeight();
        }
        if ((double)(width = (int)(750.0f * zoom)) > screenSize.getWidth()) {
            width = (int)screenSize.getWidth();
        }
        Dimension dimension = new Dimension(width, height);
        this.setSize(dimension);
        this.setLocation((screenSize.width - width) / 2, (screenSize.height - height) / 2);
    }

    void exitForm() {
        if (this.isExitOnClose) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.viewer.clear();
            this.viewer = null;
            this.getContentPane().removeAll();
            this.dispose();
        }
    }

    public void setZoomRatio(float zoomRatio) {
        this.viewer.setZoomRatio(zoomRatio);
    }

    public void setFitWidthZoomRatio() {
        this.viewer.setFitWidthZoomRatio();
    }

    public void setFitPageZoomRatio() {
        this.viewer.setFitPageZoomRatio();
    }

    private static void usage() {
        System.out.println("JasperViewerDialog usage:");
        System.out.println("\tjava JasperViewerDialog -XML -Ffile");
    }

    public static void viewReport(String sourceFile, boolean isXMLFile) throws JRException {
        JasperViewerDialog.viewReport(sourceFile, isXMLFile, true, null);
    }

    public static void viewReport(InputStream is, boolean isXMLFile) throws JRException {
        JasperViewerDialog.viewReport(is, isXMLFile, true, null);
    }

    public static void viewReport(JasperPrint jasperPrint) {
        JasperViewerDialog.viewReport(jasperPrint, true, null);
    }

    public static void viewReport(String sourceFile, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        JasperViewerDialog.viewReport(sourceFile, isXMLFile, isExitOnClose, null);
    }

    public static void viewReport(InputStream is, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        JasperViewerDialog.viewReport(is, isXMLFile, isExitOnClose, null);
    }

    public static void viewReport(JasperPrint jasperPrint, boolean isExitOnClose) {
        JasperViewerDialog.viewReport(jasperPrint, isExitOnClose, null);
    }

    public static void viewReport(String sourceFile, boolean isXMLFile, boolean isExitOnClose, Locale locale) throws JRException {
        JasperViewerDialog jasperViewer = new JasperViewerDialog(sourceFile, isXMLFile, isExitOnClose, locale);
        jasperViewer.setVisible(true);
    }

    public static void viewReport(InputStream is, boolean isXMLFile, boolean isExitOnClose, Locale locale) throws JRException {
        JasperViewerDialog jasperViewer = new JasperViewerDialog(is, isXMLFile, isExitOnClose, locale);
        jasperViewer.setVisible(true);
    }

    public static void viewReport(JasperPrint jasperPrint, boolean isExitOnClose, Locale locale) {
        JasperViewerDialog jasperViewer = new JasperViewerDialog(jasperPrint, isExitOnClose, locale);
        jasperViewer.setVisible(true);
    }
}

